clear
close all
clc

cd('D:\Projects\DLR\INFORM')

cd('D:\Projects\DLR\Majella\Majella')

filename = 'Majella_1_rad_geo_atm_nointerp.bsq';

wavelength = {
 0.436500, 0.452000, 0.464400, 0.480400, 0.495200, 0.510100, 0.525900,
 0.541500, 0.556800, 0.571900, 0.587100, 0.602500, 0.618000, 0.633500,
 0.648700, 0.663800, 0.679000, 0.694400, 0.709800, 0.724900, 0.740000,
 0.755200, 0.770300, 0.785200, 0.800300, 0.815600, 0.830700, 0.846000,
 0.861300, 0.876500, 0.888600, 0.894800, 0.911200, 0.927100, 0.943100,
 0.959100, 0.974600, 0.990300, 1.006300, 1.021800, 1.037200, 1.052600,
 1.067900, 1.083000, 1.097900, 1.112800, 1.127800, 1.142300, 1.156800,
 1.171500, 1.186100, 1.200400, 1.214600, 1.228900, 1.243200, 1.257400,
 1.271500, 1.285500, 1.299400, 1.313200, 1.327200, 1.340700, 1.409300,
 1.423600, 1.437800, 1.452000, 1.465800, 1.480000, 1.494000, 1.507600,
 1.521000, 1.534600, 1.548200, 1.561500, 1.574700, 1.587900, 1.600900,
 1.613800, 1.626700, 1.639700, 1.652600, 1.665100, 1.677600, 1.690200,
 1.702700, 1.715000, 1.727300, 1.739700, 1.751900, 1.763900, 1.775900,
 1.788000, 1.799900, 1.811500, 1.952900, 1.971700, 1.990600, 2.009700,
 2.028700, 2.047400, 2.065700, 2.083800, 2.101700, 2.119800, 2.137800,
 2.155700, 2.173000, 2.189700, 2.207400, 2.225400, 2.242500, 2.260000,
 2.276700, 2.293400, 2.309800, 2.326300, 2.342800, 2.359400, 2.375600,
 2.391400, 2.407200, 2.422900, 2.438700, 2.454600, 2.470200, 2.485300};

wl = cell2mat(wavelength(:)); wl = reshape(wl,[18 7]); wl = wl'; wl = 1000*wl(:);
clear wavelength

% Info from header file (hdr)
samples = 1790;     % columns
lines   = 11824;    % rows
bands   = 126;      % layers

size = [lines samples bands];

offset = 0;
interleave = 'bsq';
byteorder = 'ieee-le';
precision = 'int16';

% REFL_CUBE = multibandread(filename, size, precision, offset, interleave, byteorder,{'Band','Direct',[10,23,64]});
REFL_CUBE = multibandread(filename, size, precision, offset, interleave, byteorder, {'Row','Range',[1001, 2000]}, {'Column','Range',[101, 1000]});

cd('D:\Projects\DLR\INFORM')

% Scaling the data into BoA reflectance
REFL_CUBE = REFL_CUBE/10000;


figure(1)
imagesc(REFL_CUBE(:,:,[10 55 100]))

figure(2)
plot(wl,squeeze(REFL_CUBE(955,375,:)),'-o')
title('Observed reflectance spectrum')
xlabel('wavelength (in nm)')
ylabel('BoA reflectance')

r_example = squeeze(REFL_CUBE(955,375,:));

save temp r_example
