% INFORM script ... for execution of the RTM
%
% The model reads (& should be executed) as follows: 
%
% [r_forest,R_SOIL,r_understorey,r_c_inf,co,C,G,r_leaf,t_leaf,t_s,t_o]= ...
%    inform(PARA_PROSPECT,PARA_INFORM,teta_o,teta_s,phi,skyl,r_soil, bands);
%
% The execution requires that the following files are available 
%
% inform.m                  Main INFORM code
% sail_background.m         SAIL-PROSPECT-SOIL to compute background reflectance         
% sail_inf.m                SAIL-PROSPECT-SOIL to compute infinite crown reflectance
% sail_t_s.m                SAIL-PROSPECT-SOIL to compute crown transmittance for sun direction
% sail_t_o.m                SAIL-PROSPECT-SOIL to compute crown transmittance for observation direction   
% prospect.m                Leaf reflecance model PROSPECT
% s13aaf.M                  Integral for PROSPECT
% tav.M                     Refraction index for PROSPECT
% dataspec                  Absorption coefficients for PROSPECT
% r_soil.csv                Bare soil reflectance spectrum (421 wl's)
% lambda.csv                Wavelength of bare soil reflectance spectrum
%
% Scale factor for soil reflectance     scale                       1
% Single tree leaf area index           lai             m2 m-2      7
% Leaf area index of understorey	    laiu	        m2 m-2	    0.1
% Stem density                          sd              ha-1        650
% Tree height                           h               m           20
% Crown diameter                        cdia            m           4.5
% Average leaf angle of tree canopy	    ala             deg         55
%
% leaf structure parameter              N               -           2
% chlorophyll a+b content in            Cab             g/cm      60      
% equivalent water thickness            Cw              g/cm       0.025
% dry matter content                    Cm              g/cm       0.025
%
% C Atzberger, Vienna, July 2017

clear
close all
clc

cd('D:\Projects\DLR\INFORM')

% The INFORM simulations will be done for the 421 wavelengths of PROSPECT
% model (every 5 nm from 400nm to 2500nm) ... Simulated band numbers can be
% chosen by user (for all bands: bands  = 1:421) ... here some examples
%
% You chose 5 arbitrary bands ....  bands = [11 25 55 125 400];
% You chose all bands available ....bands = 1:421;
load bands % You load the bands for the test data set

% SAIL/INFORM parameters
scale = 1;
lai = 7;
laiu = 0.1;
sd = 650;
h = 20;
cdia = 4.5;
ala = 55;

% PROSPECT parameters
N = 2;
Cab = 60;
Cw = 0.025;
Cm = 0.025;

PARA_INFORM(1) = scale;
PARA_INFORM(2) = lai;
PARA_INFORM(3) = laiu;
PARA_INFORM(4) = sd;
PARA_INFORM(5) = h;
PARA_INFORM(6) = cdia;
PARA_INFORM(7) = ala;

PARA_PROSPECT(1) = N;
PARA_PROSPECT(2) = Cab;
PARA_PROSPECT(3) = Cw;
PARA_PROSPECT(4) = Cm;

cd('D:\Projects\DLR\INFORM\INFORM_V5')

% Loads soil reflectance spectrum [r_soil]
load r_soil.csv

% Observation conditions
teta_o = 30;    % Observation zenith angle
teta_s = 0;     % View zenith angle
phi = 0;        % Relative azimuth
skyl = 0.1;     % Fraction of diffuse illumination

% Loads the wavelengths for which PROSPECT simulates leaf reflectance and
% transmittance
dataspec
lambda = data(bands,1);


% Execution of the parameterized model
%
% Outputs:
% r_forest     : forest spectral reflectance
% R_SOIL       : scaled bare soil spectral reflctance
% r_understory : understory spectral reflectance
% r_c_inf      : infinitive forest cover spectral reflectance
% co           : ground coverage  by crowns under observation zenith angle
% C            : FLIMs crown factor; crown's contribution to reflectance
% G            : FLIMs ground factor; ground's contribution to reflectance
% r_leaf       : leaf spectral reflectance
% t_leaf       : leaf spectral transmittance
% t_s          : crown transmittance in sun direction
% t_o          : crown transmittance in observation direction
[r_forest,R_SOIL,r_understorey,r_c_inf,co,C,G,r_leaf,t_leaf,t_s,t_o] = ...
    inform(PARA_PROSPECT,PARA_INFORM,teta_o,teta_s,phi,skyl,r_soil, bands);

cd('D:\Projects\DLR\INFORM')

figure
plot(lambda,r_forest,'o-')
title('Simulated reflectance spectrum')
xlabel('wavelength (in nm)')
ylabel('BoA reflectance')
break

load temp
figure
plot(lambda,r_example,'*')
title('Observed reflectance spectrum')
xlabel('wavelength (in nm)')
ylabel('BoA reflectance')
