% ----------- TRANS_O(l,ala,hot,cab,cw,vai,to,skyl) --------------
% l     : LAI                        
% ala   : angle moyen d'inclinaison des feuilles
% hot   : parametre hotspot: rapport entre diametre feuille et hauteur strate
% refl  : reflectance des feuilles   tran: transmittance des feuilles
% cab   : Chlorphyllkonzentration
% cw    : Wassergehalt der Bltter
% vai   : Void Area Index
% to    : angle zenithal d'obsevation
% ts    : angle zenithal solaire
% psi   : angle azimutal entre observation et soleil
% skyl  : diffuser Strahlungsanteil
%
% Clement Atzberger im November 1995

function trans_hemi=sail_t_o(l,ala,hot,to,skyl,SOILREFL,ts,phi,refl,tran)

	% Bodenreflexion
rs1=SOILREFL;
rs2=rs1;
rs3=rs1;

ts=to;
	
	% Umwandlung der Grad-Werte in Radian f?r SAIL-Modell
ts=ts*pi/180;
to=to*pi/180;
psi=phi*pi/180;


	% ------ Beginn des SAIL-Modells       ------------ %
%
%-------------------initialisation des valeurs
%

a=0;
sig=0;
ks=0;
ko=0;
s=0;
ss=0;
u=0;
v=0;
wo=0;
w=0;
rtp=(refl+tran).*0.5;
rtm=(refl-tran).*0.5;
tgs=tan(ts);
tgo=tan(to);
cos_psi=cos(psi);
dso=sqrt(abs(tgs.^2+tgo.^2-2*tgs.*tgo.*cos_psi));
alf=1e6;
if hot>0; alf=dso./hot; end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% calcul de la distribution des inclinaison foliaires
%
excent=exp(-1.6184e-5.*ala.^3+2.1145e-3.*ala.^2-1.2390e-1.*ala+3.2491);
tlref=[5 15 25 35 45 55 64 72 77 79 81 83 85 87 89];
alpha1=[10 20 30 40 50 60 68 76 78 80 82 84 86 88 90];
alpha2=[0 alpha1(1,1:14)];
ff=zeros(15,0);

%
% -----------calcul des frequences relatives
%

tlref=tlref'*pi/180;
alpha1=alpha1'*pi/180;
alpha2=alpha2'*pi/180;
x1=excent./sqrt(1+excent.^2..*tan(alpha1).^2);
x2=excent./sqrt(1+excent.^2..*tan(alpha2).^2);
   if excent == 1
      ff=abs(cos(alpha1)-cos(alpha2));
   else
     a1=excent./sqrt(abs(1-excent.^2));
     a12=a1 .^2;
     x12=x1 .^2;
     x22=x2 .^2;
     a1px1=sqrt(a12+x12);
     a1px2=sqrt(a12+x22);
     a1mx1=sqrt(a12-x12);
     a1mx2=sqrt(a12-x22);
       if excent >1
	 ff=x1.*a1px1+a12.*log(x1+a1px1);
	 ff=abs(ff-(x2.*a1px2+a12.*log(x2+a1px2)));
       else
	 ff=x1.*a1mx1+a12.*asin(x1./a1);
	 ff=abs(ff-(x2.*a1mx2+a12.*asin(x2./a1)));
       end  
    end
ff=ff./sum(ff);

%
%----------boucle sur les classes d'angle-------------
%
for i=1:15
       tl=tlref(i);
       snl=sin(tl);
       sn2l=snl.^2;
       csl=cos(tl);
       cs2l=csl.^2;
       tgl=tan(tl);
       % calcul de betas, beta0, beta1, beta2, beta3
	  bs=pi;
	  bo=pi;
	  if ((tl + ts) > pi/2); bs=acos(-1./(tgs.*tgl));end
	  if ((tl + to) > pi/2); bo=acos(-1./(tgo.*tgl));end
       bt1=abs(bs-bo);
       bt2=2*pi-bs-bo;
	     if (psi < bt1)
	       b1=psi;
	       b2=bt1;
	       b3=bt2;
	     elseif (psi > bt2)
	       b1=bt1;
	       b2=bt2;
	       b3=psi;
	     else
	       b1=bt1;
	       b2=psi;
	       b3=bt2;
	     end
       % calcul des coefficients de diffusion
       fl=ff(i).*l;
       a=a+(1-rtp+rtm.*cs2l).*fl;
       sig=sig+(rtp+rtm.*cs2l).*fl;
       sks=((bs-pi*0.5).*csl+sin(bs).*tgs.*snl).*2./pi;
       sko=((bo-pi*0.5).*csl+sin(bo).*tgo.*snl).*2./pi;
       ks=ks+sks.*fl;
       ko=ko+sko.*fl;
       s=s+(rtp.*sks+rtm.*cs2l).*fl;
       ss=ss+(rtp.*sks+rtm.*cs2l).*fl;
       u=u+(rtp*sko-rtm.*cs2l).*fl;
       v=v+(rtp*sko+rtm.*cs2l).*fl;
 %      ci1=sn2l.*tgs.*tgo;
 %      ci2=2*cs2l+ci1.*cos_psi);
 %      ci3=sin(b2).*(2.*cs2l./(cos(bs).*cos(bo))+cos(b1).*cos(b3).*ci1);
 %      wo=wo+((pi.*refl.*0.5-b2.*rtp).*ci2+rtp.*ci3).*fl./pi;
       tsin=sn2l.*tgs.*tgo/2;
       t1=cs2l+tsin.*cos_psi;
       t2=0;    
	   if b2 > 0 
	      t3=tsin*2;
	      if (bs == pi)|(bo == pi); t3=cs2l./(cos(bs).*cos(bo)); end
	      t2=-b2.*t1+sin(b2).*(t3+cos(b1).*cos(b3).*tsin);
	   end
	w=w+(refl.*t1+2*rtp.*t2/pi).*fl;
end

% calcul des variables intermediaires

m=sqrt(a.^2-sig.^2);
h1=(a+m)./sig;
h2=1../h1;
cks=ks.^2-m.^2;
cko=ko.^2-m.^2;
co=(v.*(ko-a)-u.*sig)./cko;
cs=(ss.*(ks-a)-s.*sig)./cks;
do=(-u.*(ko+a)-v.*sig)./cko;
ds=(-s.*(ks+a)-ss.*sig)./cks;
ho=(s.*co+ss.*do)./(ko+ks);

% calcul des reflectances et transmittances d'une strate.

tss=exp(-ks);
too=exp(-ko);
g=h1.*exp(m)-h2.*exp(-m);
rdd=(exp(m)-exp(-m))./g;
tdd=(h1-h2)./g;
rsd=cs.*(1-tss.*tdd)-ds.*rdd;
tsd=ds.*(tss-tdd)-cs.*tss.*rdd;
rdo=co.*(1-too.*tdd)-do.*rdd;
tdo=do.*(too-tdd)-co.*too.*rdd;
rsod=ho.*(1-tss.*too)-co.*tsd.*too-do.*rsd;

% calcul du terme hot-spot;

sumint=0;
if alf==0
   tsstoo=tss;
   sumint=(1-tss)./ks;
else
   fhot=sqrt(ko.*ks);
     x1=0;
     y1=0;
     f1=1;
     fint=(1-exp(-alf)).*.05;
	for istep=1:20
	   if istep < 20
	      x2=-log(1-istep.*fint)./alf;
	   else
	      x2=1;
	   end
	   y2=-(ko+ks).*x2+fhot.*(1-exp(-alf.*x2))./alf;
	   f2=exp(y2);
	   sumint=sumint+(f2-f1).*(x2-x1)./(y2-y1);
	   x1=x2;
	   y1=y2;
	   f1=f2;
	end
    tsstoo=f1;
end
rsos=w.*sumint;
rso=rsos+rsod;

% calcul des reflectances hemispheriques-directionnelles (zd)
% et bidirectionnelle (zs);

xo=1-rs3.*rdd;
zd=rdo+tdd.*(rs3.*tdo+rs2.*too)./xo;
zs=rso+tsstoo.*rs1+((tss.*rs2+tsd.*rs3).*tdo+(tsd+tss.*rs2.*rdd).*rs2.*too)./xo;

ED=skyl;
ES=1-skyl;

TSD=tss+(tsd+tss.*rs1.*rdd)./(1-rs1.*rdd);
TDD=tdd./(1-rs1.*rdd);

trans_hemi=(TSD*ES+TDD*ED)./(ES+ED);
