% ***********************************************************************
% s13aaf.m
% ***********************************************************************
% Exponential integral function
% y = s13aaf(x) is the integral from x to Inf of (exp(-t)/t) dt
% ***********************************************************************

function f=s13aaf(k)

if k<=4

x=0.5*k-1;
y=-3.60311230482612224d-13.*x+3.46348526554087424d-12;
y=y.*x-2.99627399604128973d-11;
y=y.*x+2.57747807106988589d-10;
y=y.*x-2.09330568435488303d-9;
y=y.*x+1.59501329936987818d-8;
y=y.*x-1.13717900285428895d-7;
y=y.*x+7.55292885309152956d-7;
y=y.*x-4.64980751480619431d-6;
y=y.*x+2.63830365675408129d-5;
y=y.*x-1.37089870978830576d-4;
y=y.*x+6.47686503728103400d-4;
y=y.*x-2.76060141343627983d-3;
y=y.*x+1.05306034687449505d-2;
y=y.*x-3.57191348753631956d-2;
y=y.*x+1.07774527938978692d-1;
y=y.*x-2.96997075145080963d-1;
y=y.*x+8.64664716763387311d-1;
y=y.*x+7.42047691268006429d-1;
f=y-log(k);

elseif k>=85

f=0

else

x=14.5./(k+3.25)-1;
y=-1.62806570868460749d-12.*x-8.95400579318284288d-13;
y=y.*x-4.08352702838151578d-12;
y=y.*x-1.45132988248537498d-11;
y=y.*x-8.35086918940757852d-11;
y=y.*x-2.13638678953766289d-10;
y=y.*x-1.10302431467069770d-9;
y=y.*x-3.67128915633455484d-9;
y=y.*x-1.66980544304104726d-8;
y=y.*x-6.11774386401295125d-8;
y=y.*x-2.70306163610271497d-7;
y=y.*x-1.05565006992891261d-6;
y=y.*x-4.72090467203711484d-6;
y=y.*x-1.95076375089955937d-5;
y=y.*x-9.16450482931221453d-5;
y=y.*x-4.05892130452128677d-4;
y=y.*x-2.14213055000334718d-3;
y=y.*x-1.06374875116569657d-2;
y=y.*x-8.50699154984571871d-2;
y=y.*x+9.23755307807784058d-1;
f=exp(-k).*y./k;

end
